// Copyright David Abrahams 2005. Distributed under the Boost
// Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
#ifndef ADAPTERS_DWA2005621_HPP
# define ADAPTERS_DWA2005621_HPP

class Vector
{
    float& operator[](std::size_t N);
    float const& operator[](std::size_t N) const;
};

template <class M>
class reverse_view
{
    reverse_view(M& x) : x(x) {}
    
    float& operator[](std::size_t n) const
    {
        return x[x.size() - n];
    }
    
    M& x;
};

template <class M>
class reverse_view<M const>
{
    reverse_view(M const& x) : x(x) {}
    
    float const& operator[](std::size_t n) const
    {
        return x[x.size() - n];
    }
    
    M const& x;
};

template <class M>
reverse_view<M> const
reverse(M&);

template <class M>
reverse_view<M const> const
reverse(M const&);

template <class V>
void unique(V&);

  ...
{
  unique(reverse(v));

}

============ The Old Way ========

    

#endif // ADAPTERS_DWA2005621_HPP
