// Copyright David Abrahams 2005. Distributed under the Boost
// Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
#ifndef BOOST_SEQUENCE_SIZE_DWA200559_HPP
# define BOOST_SEQUENCE_SIZE_DWA200559_HPP

# include <boost/sequence/extent.hpp>

namespace boost { namespace sequence { 

template <class Sequence>
typename extent<Sequence>::type
size(Sequence const& s)
{
    return sequence::end(s) - sequence::begin(s);
}
    
}} // namespace boost::sequence

#endif // BOOST_SEQUENCE_SIZE_DWA200559_HPP
