// -*-C++-*- timer.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2005 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   

// ----------------------------------------------------------------------- 

#if !defined(COOL_TIMER_HPP)
#define COOL_TIMER_HPP 1

#include <sys/time.h>
#include <ostream>

namespace cool
{
  // ---------------------------------------------------------------------

  struct timer
  {
    timer() { gettimeofday(&m_beg, 0); }

    unsigned long elapsed_ms() const
    {
      struct timeval end;
      gettimeofday(&end, 0);
      return (end.tv_sec - m_beg.tv_sec) * 1000
	+ (end.tv_usec - m_beg.tv_usec) / 1000;
    }

    double elapsed() const
    {
      return elapsed_ms() / 1000.0;
    }
  
  private:
    struct timeval m_beg;
  };

// ----------------------------------------------------------------------- 

  struct fmt
  {
    fmt(int w, int p): m_width(w), m_precision(p) {}
    int m_width;
    int m_precision;
  };

  std::ostream& operator<< (std::ostream& os, fmt const& f)
  {
    os.width(f.m_width);
    os.precision(f.m_precision);
    return os << std::fixed;
  }

  // ---------------------------------------------------------------------
} // namespace cool

#endif /* COOL_TIMER_HPP */
