  #include "cool/algorithm/lower_bound.hpp"
  #include "cool/functional/less.hpp"
  #include "cool/traits/array_traits.hpp"
  #include "testpm.hpp"
  #include <iostream>

  // -------------------------------------------------------------------- 

  template <typename T, int sz, typename LowerBound>
  void check(T (&a)[sz], LowerBound lower_bound, T const& val)
  {
    std::cout << val << " -> " << (lower_bound(cool::begin(a), cool::end(a), val) - cool::begin(a)) << ": "
	      << *lower_bound(cool::begin(a), cool::end(a), val) << "\n";
  }

  template <typename LowerBound>
  void check(LowerBound lower_bound)
  {
    int a1[] = { 2, 4, 6, 8, 10, 12 };
    int a2[] = { 2, 2, 2, 2, 4, 4, 6, 6, 6, 8, 10, 12 };

    for (int i = 0; i < 14; ++i)
    {
      check(a1, lower_bound, i);
      //check(a2, lower_bound, i);
    }
  }

  // -------------------------------------------------------------------- 

  int* lower_bound0(int* b, int* e, int v) { return cool::lower_bound(b, e, v); }
  int* lower_bound1(int* b, int* e, int v) { return cool::lower_bound(b, e, v, cool::less<int>()); }
  int* lower_bound2(int* b, int* e, int v) { return cool::lower_bound(b, e, v, testtools::times_pm<int>(2)); }
  int* lower_bound3(int* b, int* e, int v) { return cool::lower_bound(b, e, v, cool::less<int>(), testtools::times_pm<int>(2)); }

  // -------------------------------------------------------------------- 

  int main(int ac, char *av[])
  {
    switch (ac == 1? '0': av[1][0])
      {
      case '0': check(lower_bound0); break;
      case '1': check(lower_bound1); break;
      case '2': check(lower_bound2); break;
      case '3': check(lower_bound3); break;
      default:
        std::cout << "no such test\n";
      }

    return 0;
  }
