// -*-C++-*- testpm.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   
// Version: $Id: testpm.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(TESTPM_HPP)
#define TESTPM_HPP 1

namespace testtools
{
  // -------------------------------------------------------------------- 

  template <typename T>
  struct times_pm
  {
    typedef T key_type;
    typedef T value_type;

    times_pm(T f): factor(f) {}
    T factor;
  };

  template <typename T, typename Key>
  T get(times_pm<T> const& pm, Key const& key)
  {
    return pm.factor * key;
  }


  template <typename T, typename Key>
  void put(times_pm<T> const& pm, Key& key, T const& val)
  {
    key = pm.factor * val;
  }

  // ------------------------------------------------------------------------

} // namespace testtools

#endif /* TESTPM_HPP */
