// -*-C++-*- include/testiterator.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   
// Version: $Id: testiterator.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(TESTITERATOR_HPP)
#define TESTITERATOR_HPP 1

namespace testtools
{

  // ------------------------------------------------------------------------

  template <typename T> void require(T const&) {}

  // ------------------------------------------------------------------------

  template <typename T, typename Category>
  struct iterator
  {
    iterator(T* b): base(b) {}

    typedef T              value_type;
    typedef T              key_type;
    typedef T*             pointer;
    typedef T&             reference;
    typedef std::ptrdiff_t difference_type;
    typedef Category       iterator_category;

    bool operator== (iterator<T, Category> const& it) const { require<cool::input_iterator_tag>(Category()); return base == it.base; }
    bool operator!= (iterator<T, Category> const& it) const { require<cool::input_iterator_tag>(Category()); return base != it.base; }

    T&                     operator*() { require<cool::input_iterator_tag>(Category()); return *base; }
    T*                     operator->() { require<cool::input_iterator_tag>(Category()); return base; }
    iterator<T, Category>& operator++() { require<cool::input_iterator_tag>(Category()); ++base; return *this; }
    difference_type        operator- (iterator<T, Category> const& it) const {
      require<cool::random_access_iterator_tag>(Category());
      return base - it.base;
    }
  private:
    T* base;
  };

  // ------------------------------------------------------------------------

} // namespace testtools

#endif /* TESTITERATOR_HPP */
