// -*-C++-*- segments.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2005 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   The basic definitions for segmented sequences

// ----------------------------------------------------------------------- 
// This file declares several class templates needed for the segmented
// iterator concept. The elements of this concepts are the following

// C  is a cursor type
// c  is an object of type C
// S  is a cursor type for a sequence of segments
// s  is an object of type S
// L  is a cursor type for the elements of a segment
// l  is an object of type L

// Expression                     Result   Semantic
// ==========                     ======   ========
// cool::is_segmented<C>::value   bool     compile-time; true if C
//                                         accesses a segmented sequence
// cool::segment_cursor<C>::type  type S   cursor type for sequence of segments
// cool::local_cursor<C>::type    type L   cursor type for segment elements
// segment(c)                     S        cursor at segment of c
// local(c)                       L        local cursor at the same element as c
// local_begin(s)                 L        begin of s's elements
// local_end(s)                   L        end of s's elements
// make_segmented(s, l)           C        cursor at the same element as l
// ----------------------------------------------------------------------- 

#if !defined(COOL_SEGMENTS_HPP)
#define COOL_SEGMENTS_HPP 1

namespace cool
{
  // ---------------------------------------------------------------------

  template <typename>
  struct is_segmented { enum { value = false }; };

  template <typename> struct segment_cursor;
  template <typename> struct local_cursor;

  // ---------------------------------------------------------------------
}

#endif /* COOL_SEGMENTS_HPP */
