// -*-C++-*- include/cool/utility/bool.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   types for boolean expressions in meta programming
// Version: $Id: bool.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_UTILITY_BOOL_HPP)
#define COOL_UTILITY_BOOL_HPP 1

namespace cool
{

  // ------------------------------------------------------------------------

  struct true_t {};
  struct false_t {};

  // ------------------------------------------------------------------------

  template <bool b> struct bool_to_type;
  template <> struct bool_to_type<true>  { typedef true_t  type; };
  template <> struct bool_to_type<false> { typedef false_t type; };

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_UTILITY_BOOL_HPP */
