// -*-C++-*- inlcude/cool/traits/stream_traits.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   traits easing algorithm/stream integration
// Version: $Id: stream_traits.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_TRAITS_STREAM_TRAITS_HPP)
#define COOL_TRAITS_STREAM_TRAITS_HPP 1

#include <istream>
#include <ostream>
#include <iterator>

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename T, typename cT, typename traits>
  inline std::ostream_iterator<T>
  begin(std::basic_ostream<cT, traits>& stream, cT const* fieldterm)
  {
    return std::ostream_iterator<T>(stream, fieldterm);
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_TRAITS_STREAM_TRAITS_HPP */
