// -*-C++-*- cool/traits/property.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   Traits to find out details about property maps
// Version: $Id: property.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_TRAITS_PROPERTY_HPP)
#define COOL_TRAITS_PROPERTY_HPP 1

#if !defined(COOL_TRAITS_PROPERTY_FWD_HPP)
#  include "cool/traits/property_fwd.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_UTILITY_BOOL_HPP)
#  include "cool/utility/bool.hpp"
#endif

namespace cool
{
  // ------------------------------------------------------------------------
  // the general case obtains the traits from the property map:

  template <typename PM, typename Key>
  struct property_use_traits
  {
    typedef typename PM::value_type value_type;
    typedef typename PM::key_type   key_type;
  };

  // ------------------------------------------------------------------------

  template <typename Property, typename Iterator>
  struct property_traits
  {
    typedef typename cool::iterator_traits<Iterator>::key_type key_type;
    typedef typename cool::property_use_traits<Property, key_type>::value_type value_type;
  };

  // ------------------------------------------------------------------------

  namespace is_pm_auxiliary
  {
    typedef char char1[1];
    typedef char char2[2];

    struct aux {};
    template <typename T> char1& aux_func(T const&);
    char2& aux_func(cool::is_pm_auxiliary::aux const&);

    template <typename S, typename T> cool::is_pm_auxiliary::aux get(S const&, T const&, ...);
    template <typename T> T& get_ref();

    template <typename T, typename Iterator>
    struct is_read_pm
    {
      enum { val = sizeof(cool::is_pm_auxiliary::aux_func(get(cool::is_pm_auxiliary::get_ref<T>(),
							      *cool::is_pm_auxiliary::get_ref<Iterator>()))) };
    };
  }

  template <typename T, typename Iterator>
  struct is_read_pm
  {
    enum { flag = cool::is_pm_auxiliary::is_read_pm<T, Iterator>::val == sizeof(cool::is_pm_auxiliary::char1)? true: false };
    typedef typename cool::bool_to_type<flag>::type type;
  };

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_TRAITS_PROPERTY_HPP */
