// -*-C++-*- cool/traits/iterator.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   traits to deal with iterators
// Version: $Id: iterator.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_TRAITS_ITERATOR_HPP)
#define COOL_TRAITS_ITERATOR_HPP 1

#if !defined(COOL_TRAITS_ITERATOR_FWD_HPP)
#  include <cool/traits/iterator_fwd.hpp>
#endif
#include <iterator>

namespace cool
{
  // ------------------------------------------------------------------------

  struct input_iterator_tag {};
  struct output_iterator_tag {};
  struct forward_iterator_tag: input_iterator_tag {};
  struct bidirectional_iterator_tag: forward_iterator_tag {};
  struct random_access_iterator_tag: bidirectional_iterator_tag {};

  // ------------------------------------------------------------------------

  template <typename Category> struct map_tag_type { typedef Category type; };
  template <> struct map_tag_type<std::input_iterator_tag> { typedef cool::input_iterator_tag type; };
  template <> struct map_tag_type<std::output_iterator_tag> { typedef cool::output_iterator_tag type; };
  template <> struct map_tag_type<std::forward_iterator_tag> { typedef cool::forward_iterator_tag type; };
  template <> struct map_tag_type<std::bidirectional_iterator_tag> { typedef cool::bidirectional_iterator_tag type; };
  template <> struct map_tag_type<std::random_access_iterator_tag> { typedef cool::random_access_iterator_tag type; };
  

  // ------------------------------------------------------------------------

  template <typename It>
  struct iterator_traits
  {
    typedef typename std::iterator_traits<It>::value_type        key_type;
    typedef typename std::iterator_traits<It>::difference_type   difference_type;
    typedef typename std::iterator_traits<It>::iterator_category std_category;
    typedef typename map_tag_type<std_category>::type            iterator_category;
  };

  // ------------------------------------------------------------------------
} // namespace cool

#endif /* COOL_TRAITS_ITERATOR_HPP */
