// -*-C++-*- array_traits.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   traits to ease the use of arrays
// Version: $Id: array_traits.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_TRAITS_ARRAY_TRAITS_HPP)
#define COOL_TRAITS_ARRAY_TRAITS_HPP 1

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#include <cstddef>

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename T, int sz>
  T const* begin(T const (&array)[sz])
  {
    return array;
  }

  template <typename T, int sz>
  T* begin(T (&array)[sz])
  {
    return array;
  }

  template <typename T, int sz>
  T const* end(T const (&array)[sz])
  {
    return sz + array;
  }

  template <typename T, int sz>
  std::size_t size(T (&)[sz])
  {
    return sz;
  }

  template <typename T, int sz>
  T* end(T (&array)[sz])
  {
    return sz + array;
  }

  template <typename T, int sz>
  identity_map map(T const (&array)[sz])
  {
    return identity_map();
  }

  template <typename T, int sz>
  identity_map map(T (&)[sz])
  {
    return identity_map();
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_TRAITS_ARRAY_TRAITS_HPP */
