// -*-C++-*- cool/property/pair.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   property maps for use with std::pair-like types
// Version: $Id: pair.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_PROPERTY_PAIR_HPP)
#define COOL_PROPERTY_PAIR_HPP 1

#if !defined(COOL_PROPERTY_TRAITS_FWD_HPP)
#  include <cool/property/traits.hpp>
#endif

namespace cool
{
  // ------------------------------------------------------------------------

  struct first_map {};

  template <typename Key>
  struct property_use_traits<first_map, Key>
  {
    typedef typename Key::first_type value_type;
    typedef Key                      key_type;
  };

  // ------------------------------------------------------------------------

  template <typename Pair>
  typename Pair::first_type& get(first_map&, Pair& p)
  {
    return p.first;
  }

  template <typename Pair>
  typename Pair::first_type const& get(first_map const&, Pair const& p)
  {
    return p.first;
  }

  template <typename Pair, typename T>
  void put(first_map const&, Pair& p, T const& val)
  {
    p.first = val;
  }

  // ------------------------------------------------------------------------

  struct second_map {};

  template <typename Key>
  struct property_use_traits<second_map, Key>
  {
    typedef typename Key::second_type value_type;
    typedef Key                       key_type;
  };

  // ------------------------------------------------------------------------

  template <typename Pair>
  typename Pair::second_type& get(second_map&, Pair& p)
  {
    return p.second;
  }

  template <typename Pair>
  typename Pair::second_type const& get(second_map const&, Pair const& p)
  {
    return p.second;
  }

  template <typename Pair, typename T>
  void put(second_map const&, Pair& p, T const& val)
  {
    p.second = val;
  }

  // ------------------------------------------------------------------------
} // namespace cool

#endif /* COOL_PROPERTY_PAIR_HPP */
