// -*-C++-*- cool/iterator/stream.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   Iterators easing stream processing
// Version: $Id: stream.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ITERATOR_STREAM_HPP)
#define COOL_ITERATOR_STREAM_HPP 1

#include <ostream>

namespace cool
{
  // ------------------------------------------------------------------------

  template <typename cT, typename traits>
  class ostream_iterator
  {
  public:
    class key
    {
    public:
      key(std::basic_ostream<cT, traits>* out, cT const* sep):
	m_stream(out), m_sep(sep? sep: empty_string()), m_do_sep(false) {}
      template <typename T>
      void operator= (T const& val) {
	if (m_do_sep)
	  (*m_stream) << m_sep << val;
	else
	  m_do_sep = ((*m_stream) << val);
      }

    private:
      static cT const* empty_string() { static cT c = cT(); return &c; }
      std::basic_ostream<cT, traits>* m_stream;
      cT const*                       m_sep;
      bool                            m_do_sep;
    };

    ostream_iterator(std::basic_ostream<cT, traits>& out, cT const* sep = 0): m_key(&out, sep) {}
    ostream_iterator& operator++() { return *this; }
    key&              operator*()  { return m_key; }
  private:
    key m_key;
  };

  
  template <typename cT, typename traits>
  cool::ostream_iterator<cT, traits> begin(std::basic_ostream<cT, traits>& out, cT const* sep = 0)
  {
    return ostream_iterator<cT, traits>(out, sep);
  }

  // ------------------------------------------------------------------------
} // namespace cool

#endif /* COOL_ITERATOR_STREAM_HPP */
