// -*-C++-*- include/cool/functional/reverse_arguments.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   
// Version: $Id: reverse_arguments.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_FUNCTIONAL_REVERSE_ARGUMENTS_HPP)
#define COOL_FUNCTIONAL_REVERSE_ARGUMENTS_HPP 1

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename BinaryFunction>
  struct reverse_arguments_t
  {
    typedef typename BinaryFunction::result_type          result_type;
    typedef typename BinaryFunction::second_argument_type first_argument_type;
    typedef typename BinaryFunction::first_argument_type  second_argument_type;

    reverse_arguments_t(BinaryFunction func): m_func(func) {}
    result_type operator()(first_argument_type const& a1, second_argument_type a2) const { return m_func(a2, a1); }
    result_type operator()(first_argument_type const& a1, second_argument_type a2)       { return m_func(a2, a1); }

    BinaryFunction m_func;
  };

  // ------------------------------------------------------------------------

  template <typename BinaryFunction>
  inline reverse_arguments_t<BinaryFunction>
  reverse_arguments(BinaryFunction func)
  {
    return reverse_arguments_t<BinaryFunction>(func);
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_FUNCTIONAL_REVERSE_ARGUMENTS_HPP */
