// -*-C++-*- include/cool/functional/less.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   less functor
// Version: $Id: less.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#define COOL_FUNCTIONAL_LESS_HPP 1

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename T1, typename T2 = T1>
  struct less
  {
    typedef bool result_type;
    typedef T1   first_argument_type;
    typedef T2   second_argument_type;

    bool operator()(T1 const& o1, T2 const& o2) const { return o1 < o2; }
  };

  // ------------------------------------------------------------------------

} // namespace cool


#endif /* COOL_FUNCTIONAL_LESS_HPP */
