// -*-C++-*- include/cool/functional/bind.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   argument binders
// Version: $Id: bind.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#define COOL_FUNCTIONAL_BIND_HPP 1

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename BinaryFunction, typename T = typename BinaryFunction::second_argument_type>
  struct binder1st
  {
    typedef typename BinaryFunction::result_type          result_type;
    typedef typename BinaryFunction::second_argument_type argument_type;

    binder1st(BinaryFunction const& bf, T const& a): m_binary_function(bf), m_argument(a) {}

    result_type operator()(typename BinaryFunction::second_argument_type& a) {
      return m_binary_function(m_argument, a);
    }
    result_type operator()(typename BinaryFunction::second_argument_type& a) const {
      return m_binary_function(m_argument, a);
    }
    result_type operator()(typename BinaryFunction::second_argument_type const& a) {
      return m_binary_function(m_argument, a);
    }
    result_type operator()(typename BinaryFunction::second_argument_type const& a) const {
      return m_binary_function(m_argument, a);
    }
    
  private:
    BinaryFunction m_binary_function;
    T              m_argument;
  };

  template <typename BinaryFunction, typename T>
  inline cool::binder1st<BinaryFunction, T>
  bind1st(BinaryFunction const& bf, T const& t)
  {
    return cool::binder1st<BinaryFunction, T>(bf, t);
  }
  
  // ------------------------------------------------------------------------

  template <typename BinaryFunction, typename T = typename BinaryFunction::second_argument_type>
  struct binder2nd
  {
    typedef typename BinaryFunction::result_type         result_type;
    typedef typename BinaryFunction::first_argument_type argument_type;

    binder2nd(BinaryFunction const& bf, T const& a): m_binary_function(bf), m_argument(a) {}

    result_type operator()(typename BinaryFunction::first_argument_type& a) {
      return m_binary_function(a, m_argument);
    }
    result_type operator()(typename BinaryFunction::first_argument_type& a) const {
      return m_binary_function(a, m_argument);
    }
    result_type operator()(typename BinaryFunction::first_argument_type const& a) {
      return m_binary_function(a, m_argument);
    }
    result_type operator()(typename BinaryFunction::first_argument_type const& a) const {
      return m_binary_function(a, m_argument);
    }
    
  private:
    BinaryFunction m_binary_function;
    T              m_argument;
  };

  template <typename BinaryFunction, typename T>
  inline cool::binder2nd<BinaryFunction, T>
  bind2nd(BinaryFunction const& bf, T const& t)
  {
    return cool::binder2nd<BinaryFunction, T>(bf, t);
  }
  
  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_FUNCTIONAL_BIND_HPP */
