// -*-C++-*- include/cool/algorithm/unique_copy.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the unique_copy() family of algorithms
// Version: $Id: unique_copy.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_UNIQUE_COPY_HPP)
#define COOL_ALGORITHM_UNIQUE_COPY_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_NOT_HPP)
#  include "cool/functional/not.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: unique_copy()

  template <typename InputIterator, typename OutputIterator, typename BinaryPredicate,
	    typename ReadPM, typename WritePM, typename CopyPM>
  OutputIterator
  unique_copy(InputIterator begin1, InputIterator end1,
	      OutputIterator begin2,
	      BinaryPredicate pred,
	      ReadPM read_pm, WritePM write_pm,
	      CopyPM copy_pm)
  {
    if (begin1 != end1)
      do
      {
	put(write_pm, *begin2, get(copy_pm, *begin1));
	++begin2;
      }
      while ((begin1 = cool::find_if(begin1, end1, not1(cool::bind1st(pred, get(read_pm, *begin1))), read_pm)) != end1);
	  
    return begin2;
  }

  // ------------------------------------------------------------------------

  namespace unique_copy_aux
  {
    struct aux {};
    typedef char char1[1];
    typedef char char2[2];

    template <typename T> char1& aux_func(T const&);
    char2& aux_func(aux const&);

    template <typename S, typename T> aux get(S const&, T const&, ...);
    template <typename T> T& get_ref();

    template <typename T, typename InputIterator>
    struct is_read_pm
    {
      enum { val = sizeof(aux_func(get(get_ref<T>(), *get_ref<InputIterator>()))) };
    };

    template <int i> struct call {
      template <typename InputIterator, typename OutputIterator,
		typename Pred, typename ReadPM, typename WritePM>
      static inline OutputIterator
      unique_copy(InputIterator begin1, InputIterator end1, OutputIterator begin2,
		  Pred pred, ReadPM read_pm, WritePM write_pm)
      {
	return cool::unique_copy(begin1, end1, begin2, pred, read_pm, write_pm, read_pm);
      }
    };

    template <> struct call<sizeof(char1)> {
      template <typename InputIterator, typename OutputIterator,
		typename ReadPM, typename WritePM, typename CopyPM>
      static inline OutputIterator
      unique_copy(InputIterator begin1, InputIterator end1, OutputIterator begin2,
		  ReadPM read_pm, WritePM write_pm, CopyPM copy_pm)
      {
	typedef typename cool::iterator_traits<InputIterator>::key_type          key_type;
	typedef typename cool::property_use_traits<ReadPM, key_type>::value_type value_type;

	return cool::unique_copy(begin1, end1, begin2, cool::equal_to<value_type>(), read_pm, write_pm, copy_pm);
      }
    };
  }

  template <typename InputIterator, typename OutputIterator,
	    typename T, typename PM1, typename PM2>
  inline OutputIterator
  unique_copy(InputIterator begin1, InputIterator end1,
	      OutputIterator begin2,
	      T t, PM1 pm1, PM2 pm2)
  {
    typedef unique_copy_aux::call<unique_copy_aux::is_read_pm<T, InputIterator>::val> call_type;
    return call_type::unique_copy(begin1, end1, begin2, t, pm1, pm2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator,
	    typename ReadPM, typename WritePM>
  inline OutputIterator
  unique_copy(InputIterator begin1, InputIterator end1,
	      OutputIterator begin2,
	      ReadPM read_pm, WritePM write_pm)
  {
    return unique_copy(begin1, end1, begin2, read_pm, write_pm, read_pm);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator, typename BinaryPredicate>
  OutputIterator
  unique_copy(InputIterator begin1, InputIterator end1,
	      OutputIterator begin2,
	      BinaryPredicate pred)
  {
    return cool::unique_copy(begin1, end1, begin2, pred, cool::identity_map(), cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator>
  OutputIterator
  unique_copy(InputIterator begin1, InputIterator end1,
	      OutputIterator begin2)
  {
    return cool::unique_copy(begin1, end1, begin2, cool::identity_map(), cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_UNIQUE_COPY_HPP */
