// -*-C++-*- include/cool/algorithm/unique.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the unique() family of algorithms
// Version: $Id: unique.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_UNIQUE_HPP)
#define COOL_ALGORITHM_UNIQUE_HPP 1

#if !defined(COOL_ALGORITHM_ADJACENT_FIND_HPP)
#  include "cool/algorithm/adjacent_find.hpp"
#endif
#if !defined(COOL_ALGORITHM_UNIQUE_COPY_HPP)
#  include "cool/algorithm/unique_copy.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTIY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename BinaryPredicate,
	    typename ReadPM, typename ReadWritePM>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end, BinaryPredicate pred,
	 ReadPM read_pm, ReadWritePM readwrite_pm)
  {
    begin = cool::adjacent_find(begin, end, pred, read_pm);
    return cool::unique_copy(begin, end, begin, pred, read_pm, readwrite_pm, readwrite_pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename ReadPM, typename ReadWritePM>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end, ReadPM read_pm, ReadWritePM readwrite_pm, cool::true_t const&)
  {
    typedef typename cool::property_traits<ReadWritePM, ForwardIterator>::value_type value_type; 
    return cool::unique(begin, end, cool::equal_to<value_type>(), read_pm, readwrite_pm);
  }

  template <typename ForwardIterator, typename BinaryPredicate, typename ReadWritePM>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end, BinaryPredicate pred, ReadWritePM readwrite_pm, cool::false_t const&)
  {
    return cool::unique(begin, end, pred, readwrite_pm, readwrite_pm);
  }

  template <typename ForwardIterator, typename T, typename PM>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end, T t, PM pm)
  {
    return cool::unique(begin, end, t, pm, typename cool::is_read_pm<T, ForwardIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename ReadWritePM>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end, ReadWritePM readwrite_pm, cool::true_t const&)
  {
    return cool::unique(begin, end, readwrite_pm, readwrite_pm);
  }

  template <typename ForwardIterator, typename BinaryPredicate>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end, BinaryPredicate pred, cool::false_t const&)
  {
    return cool::unique(begin, end, pred, cool::identity_map());
  }

  template <typename ForwardIterator, typename T>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end, T t)
  {
    return cool::unique(begin, end, t, typename cool::is_read_pm<T, ForwardIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator>
  inline ForwardIterator
  unique(ForwardIterator begin, ForwardIterator end)
  {
    return cool::unique(begin, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_UNIQUE_HPP */
