// -*-C++-*- include/cool/algorithm/transform.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   transform algorithms and its variations
// Version: $Id: transform.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_TRANSFORM_HPP)
#define COOL_ALGORITHM_TRANSFORM_HPP 1

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{
  // ------------------------------------------------------------------------
  // workhorse: transform()

  template <typename InIt, typename OutIt, typename Functor, typename ReadPM, typename WritePM>
  OutIt transform(InIt beg, InIt end, OutIt to, Functor functor, ReadPM read, WritePM write)
  {
    for (; beg != end; ++beg, ++to)
      put(write, *to, functor(get(read, *beg)));
    return to;
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename OutputIterator,
	    typename UnaryFunction>
  inline OutputIterator
  transform(InputIterator begin1, InputIterator end1, OutputIterator begin2,
	    UnaryFunction functor)
  {
    return cool::transform(begin1, end1, begin2, functor, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_TRANSFORM_HPP */
