// -*-C++-*- include/cool/algorithm/swap_ranges.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the swap_ranges() family of algorithms
// Version: $Id: swap_ranges.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_SWAP_RANGES_HPP)
#define COOL_ALGORITHM_SWAP_RANGES_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#include <utility> //-dk:TODO remove

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: swap_ranges()

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename ReadWritePM1, typename ReadWritePM2>
  ForwardIterator2
  swap_ranges(ForwardIterator1 begin1, ForwardIterator1 end1,
	      ForwardIterator2 begin2,
	      ReadWritePM1 pm1, ReadWritePM2 pm2)
  {
    for (; begin1 != end1; ++begin1, ++begin2)
      cool::iter_swap(begin1, begin2, pm1, pm2);
    return begin2;
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2>
  ForwardIterator2
  swap_ranges(ForwardIterator1 begin1, ForwardIterator1 end1,
	      ForwardIterator2 begin2)
  {
    return cool::swap_ranges(begin1, end1, begin2, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------
  // workhorse: swap_ranges()

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename ReadWritePM1, typename ReadWritePM2>
  std::pair<ForwardIterator1, ForwardIterator2>
  swap_ranges(ForwardIterator1 begin1, ForwardIterator1 end1,
	      ForwardIterator2 begin2, ForwardIterator2 end2,
	      ReadWritePM1 pm1, ReadWritePM2 pm2)
  {
    for (; begin1 != end1 && begin2 != end2; ++begin1, ++begin2)
      cool::iter_swap(begin1, begin2, pm1, pm2);
    return std::make_pair(begin1, begin2);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2>
  std::pair<ForwardIterator1, ForwardIterator2>
  swap_ranges(ForwardIterator1 begin1, ForwardIterator1 end1,
	      ForwardIterator2 begin2, ForwardIterator2 end2)
  {
    return cool::swap_ranges(begin1, end1, begin2, end2, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_SWAP_RANGES_HPP */
