// -*-C++-*- include/cool/algorithm/swap.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the swap() family of algorithms
// Version: $Id: swap.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_SWAP_HPP)
#define COOL_ALGORITHM_SWAP_HPP 1

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename T1, typename T2>
  void swap(T1& value1, T2& value2)
  {
    T1 tmp(value1);
    value1 = value2;
    value2 = tmp;
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_SWAP_HPP */
