// -*-C++-*- include/cool/algorithm/sort.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the sort() family of algorithms
// Version: $Id: sort.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_SORT_HPP)
#define COOL_ALGORITHM_SORT_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_ALGORITHM_PARTITION_HPP)
#  include "cool/algorithm/partition.hpp"
#endif
#if !defined(COOL_ALGORITHM_NEXT_HPP)
#  include "cool/algorithm/next.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator, typename BinaryPredicate,
	    typename ReadPM, typename ReadWritePM>
  void
  sort(BidirectionalIterator begin, BidirectionalIterator end,
       BinaryPredicate pred,
       ReadPM read_pm, ReadWritePM readwrite_pm)
  {
    if (begin != end && cool::next(begin) != end)
    {
      BidirectionalIterator sep = cool::partition(cool::next(begin), end,
						  cool::bind2nd(pred, get(read_pm, *begin)), read_pm, readwrite_pm);

      cool::iter_swap(begin, cool::prev(sep), readwrite_pm, readwrite_pm);
      cool::sort(begin, sep, pred, read_pm, readwrite_pm);
      cool::sort(sep, end, pred, read_pm, readwrite_pm);
    }
    
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator, typename BinaryPredicate,
	    typename ReadWritePM>
  inline void
  sort(BidirectionalIterator begin, BidirectionalIterator end,
       BinaryPredicate pred,
       ReadWritePM readwrite_pm, cool::false_t const&)
  {
    sort(begin, end, pred, readwrite_pm, readwrite_pm);
  }

  template <typename BidirectionalIterator,
	    typename ReadPM, typename ReadWritePM>
  inline void
  sort(BidirectionalIterator begin, BidirectionalIterator end,
       ReadPM read_pm, ReadWritePM readwrite_pm, cool::true_t const&)
  {
    typedef typename property_traits<ReadPM, BidirectionalIterator>::value_type value_type;
    sort(begin, end, cool::less<value_type>(), read_pm, readwrite_pm);
  }

  template <typename BidirectionalIterator, typename T, typename PM>
  inline void
  sort(BidirectionalIterator begin, BidirectionalIterator end,
       T t, PM pm)
  {
    sort(begin, end, t, pm, typename cool::is_read_pm<T, BidirectionalIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator, typename BinaryPredicate>
  inline void
  sort(BidirectionalIterator begin, BidirectionalIterator end,
       BinaryPredicate pred, cool::false_t const&)
  {
    sort(begin, end, pred, cool::identity_map());
  }

  template <typename BidirectionalIterator, typename ReadWritePM>
  inline void
  sort(BidirectionalIterator begin, BidirectionalIterator end,
       ReadWritePM readwrite_pm, cool::true_t const&)
  {
    typedef typename property_traits<ReadWritePM, BidirectionalIterator>::value_type value_type;
    sort(begin, end, cool::less<value_type>(), readwrite_pm, readwrite_pm);
  }

  template <typename BidirectionalIterator, typename T>
  inline void
  sort(BidirectionalIterator begin, BidirectionalIterator end, T t)
  {
    sort(begin, end, t, typename cool::is_read_pm<T, BidirectionalIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator>
  inline void
  sort(BidirectionalIterator begin, BidirectionalIterator end)
  {
    sort(begin, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_SORT_HPP */
