// -*-C++-*- include/cool/algorithm/search_n.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the search_n() family of algorithms
// Version: $Id: search_n.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_SEARCH_N_HPP)
#define COOL_ALGORITHM_SEARCH_N_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: search_n_if()

  template <typename ForwardIterator, typename Size, typename Pred, typename ReadPM>
  ForwardIterator
  search_n_if(ForwardIterator begin, ForwardIterator end, Size size, Pred pred, ReadPM pm)
  {
    for (ForwardIterator tmp = begin; (tmp = begin = cool::find_if(tmp, end, pred, pm)) != end; )
    {
      unsigned long count = size;
      do
	if (--count == 0)
	  return begin;
      while (++tmp != end && pred(get(pm, *tmp)));
    }
    
    return begin;
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Size, typename T, typename Pred, typename ReadPM>
  ForwardIterator
  search_n(ForwardIterator begin, ForwardIterator end, Size size, T const& val, Pred pred, ReadPM pm)
  {
    return cool::search_n_if(begin, end, size, cool::bind2nd(pred, val), pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Size, typename T, typename Pred>
  ForwardIterator
  search_n(ForwardIterator begin, ForwardIterator end, Size size, T const& val, Pred pred)
  {
    return cool::search_n(begin, end, size, val, pred, cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Size, typename T>
  ForwardIterator
  search_n(ForwardIterator begin, ForwardIterator end, Size size, T const& val)
  {
    typedef typename cool::iterator_traits<ForwardIterator>::key_type T1;
    return cool::search_n(begin, end, size, val, cool::equal_to<T1, T>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_SEARCH_N_HPP */
