// -*-C++-*- include/cool/algorithm/rotate_copy.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the rotate_copy() family of algorithms
// Version: $Id: rotate_copy.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_ROTATE_COPY_HPP)
#define COOL_ALGORITHM_ROTATE_COPY_HPP 1

#if !defined(COOL_ALGORITHM_COPY_HPP)
#  include "cool/algorithm/copy.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename OutputIterator,
	    typename ReadPM, typename WritePM>
  inline OutputIterator
  rotate_copy(ForwardIterator begin, ForwardIterator middle, ForwardIterator end,
	      OutputIterator to,
	      ReadPM read_pm, WritePM write_pm)
  {
    ;
    return cool::copy(begin, middle, cool::copy(middle, end, to, read_pm, write_pm), read_pm, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename OutputIterator>
  inline OutputIterator
  rotate_copy(ForwardIterator begin, ForwardIterator middle, ForwardIterator end,
	      OutputIterator to)
  {
    return cool::rotate_copy(begin, middle, end, to, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_ROTATE_COPY_HPP */
