// -*-C++-*- include/cool/algorithm/rotate.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the rotate() family of algorithms
// Version: $Id: rotate.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_ROTATE_HPP)
#define COOL_ALGORITHM_ROTATE_HPP 1

#if !defined(COOL_ALGORITHM_SWAP_RANGES_HPP)
#  include "cool/algorithm/swap_ranges.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename ReadWritePM>
  void
  rotate(ForwardIterator begin, ForwardIterator middle, ForwardIterator end,
	 ReadWritePM pm)
  {
    if (begin != middle && middle != end)
    {
      std::pair<ForwardIterator, ForwardIterator> const& p = cool::swap_ranges(begin, middle, middle, end, pm, pm);
      if (p.first == middle)
	cool::rotate(middle, p.second, end);
      else
	cool::rotate(p.first, middle, end);
    }
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator>
  void
  rotate(ForwardIterator begin, ForwardIterator middle, ForwardIterator end)
  {
    cool::rotate(begin, middle, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_ROTATE_HPP */
