// -*-C++-*- include/cool/algorithm/reverse.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the reverse() family of algorithms
// Version: $Id: reverse.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_REVERSE_HPP)
#define COOL_ALGORITHM_REVERSE_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: reverse()

  template <typename BidirectionalIterator, typename ReadWritePM>
  void
  reverse(BidirectionalIterator begin, BidirectionalIterator end, ReadWritePM pm)
  {
    for (; begin != end && begin != --end; ++begin)
      cool::iter_swap(begin, end, pm, pm);
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator>
  void
  reverse(BidirectionalIterator begin, BidirectionalIterator end)
  {
    return reverse(begin, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_REVERSE_HPP */
