// -*-C++-*- include/cool/algorithm/remove.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   
// Version: $Id: remove.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_REMOVE_HPP)
#define COOL_ALGORITHM_REMOVE_HPP 

#if !defined(COOL_ALGORITHM_REMOVE_COPY_HPP)
#  include "cool/algorithm/remove_copy.hpp"
#endif
#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Predicate, typename ReadPM, typename WritePM>
  inline ForwardIterator
  remove_if(ForwardIterator begin, ForwardIterator end,
	    Predicate pred,
	    ReadPM read_pm, WritePM write_pm)
  {
    begin = cool::find_if(begin, end, pred, read_pm);
    return cool::remove_copy_if(begin, end, begin, pred, read_pm, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Predicate, typename ReadWritePM>
  inline ForwardIterator
  remove_if(ForwardIterator begin, ForwardIterator end, Predicate pred, ReadWritePM pm)
  {
    return cool::remove_if(begin, end, pred, pm, pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Predicate>
  inline ForwardIterator
  remove_if(ForwardIterator begin, ForwardIterator end, Predicate pred)
  {
    return cool::remove_if(begin, end, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Value, typename ReadPM, typename WritePM>
  inline ForwardIterator
  remove(ForwardIterator begin, ForwardIterator end,
	 Value const& value,
	 ReadPM read_pm, WritePM write_pm)
  {
    typedef typename cool::iterator_traits<ForwardIterator>::key_type key_type;
    typedef typename cool::property_use_traits<ReadPM, key_type>::value_type value_type;
    return cool::remove_if(begin, end, cool::bind2nd(cool::equal_to<value_type, Value>(), value), read_pm, write_pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Value, typename ReadWritePM>
  inline ForwardIterator
  remove(ForwardIterator begin, ForwardIterator end, Value const& value, ReadWritePM pm)
  {
    return cool::remove(begin, end, value, pm, pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename Value>
  inline ForwardIterator
  remove(ForwardIterator begin, ForwardIterator end, Value const& value)
  {
    return cool::remove(begin, end, value, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_REMOVE_HPP */
