// -*-C++-*- include/cool/algorithm/random_shuffle.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the random_shuffle() family of algorithms
// Version: $Id: random_shuffle.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_RANDOM_SHUFFLE_HPP)
#define COOL_ALGORITHM_RANDOM_SHUFFLE_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#include <cstdlib> //-dk:TODO remove

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: random_shuffle()

  template <typename RandomAccessIterator, typename RandGenerator, typename ReadWritePM>
  void
  random_shuffle(RandomAccessIterator begin, RandomAccessIterator end,
		 RandGenerator generator, ReadWritePM pm)
  {
    typedef typename cool::iterator_traits<RandomAccessIterator>::difference_type difference_type;
    difference_type size = end - begin;
    for (RandomAccessIterator it = begin; it != end; ++it)
      cool::iter_swap(it, begin + generator(size), pm, pm);
  }

  // ------------------------------------------------------------------------

  struct random_shuffle_generator
  {
    std::size_t operator()(std::size_t size) const
    {
      return std::size_t(std::rand() * (double(size) / RAND_MAX)) % size;
    }
  };

  // ------------------------------------------------------------------------

  namespace random_shuffle_aux
  {
    struct aux {};
    typedef char char1[1];
    typedef char char2[2];

    template <typename T> char1& aux_func(T const&);
    char2& aux_func(aux const&);

    template <typename S, typename T> aux get(S const&, T const&, ...);
    template <typename T> T& get_ref();

    template <typename T, typename RandomAccessIterator>
    struct is_read_pm
    {
      enum { val = sizeof(aux_func(get(get_ref<T>(), *get_ref<RandomAccessIterator>()))) };
    };

    template <int i> struct call {
      template <typename RandomAccessIterator, typename Generator>
      static inline void
      random_shuffle(RandomAccessIterator begin, RandomAccessIterator end, Generator generator)
      {
	cool::random_shuffle(begin, end, generator, cool::identity_map());
      }
    };

    template <> struct call<sizeof(char1)> {
      template <typename RandomAccessIterator, typename ReadPM>
      static inline void
      random_shuffle(RandomAccessIterator begin, RandomAccessIterator end, ReadPM pm)
      {
	typedef typename cool::iterator_traits<RandomAccessIterator>::key_type key_type;
	typedef typename cool::property_use_traits<ReadPM, key_type>::value_type value_type;
	
	cool::random_shuffle(begin, end, random_shuffle_generator(), pm);
      }
    };
  }

  template <typename RandomAccessIterator, typename T>
  inline void
  random_shuffle(RandomAccessIterator begin, RandomAccessIterator end, T t)
  {
    typedef random_shuffle_aux::call<random_shuffle_aux::is_read_pm<T, RandomAccessIterator>::val> call_type;
    call_type::random_shuffle(begin, end, t);
  }

  // ------------------------------------------------------------------------


  template <typename RandomAccessIterator> 
  void
  random_shuffle(RandomAccessIterator begin, RandomAccessIterator end)
  {
    cool::random_shuffle(begin, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_RANDOM_SHUFFLE_HPP */
