// -*-C++-*- include/cool/algorithm/pop_heap.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the pop_heap() family of algorithms
// Version: $Id: pop_heap.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_POP_HEAP_HPP)
#define COOL_ALGORITHM_POP_HEAP_HPP 1

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#  include "cool/algorithm/iter_swap.hpp"
#endif
#if !defined(COOL_ALGORITHM_HEAP_OPERATION_HPP)
#  include "cool/algorithm/heap_operation.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#include <cassert>

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename BinaryPredicate,
	    typename ReadPM, typename ReadWritePM>
  void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end,
	   BinaryPredicate pred,
	   ReadPM read_pm, ReadWritePM readwrite_pm)
  {
    assert(begin != end);

    --end;
    cool::iter_swap(begin, end, readwrite_pm, readwrite_pm);
    cool::heapify(begin, end, begin, pred, read_pm, readwrite_pm);
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename BinaryPredicate,
	    typename ReadWritePM>
  inline void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end,
	   BinaryPredicate pred,
	   ReadWritePM readwrite_pm, cool::false_t const&)
  {
    pop_heap(begin, end, pred, readwrite_pm, readwrite_pm);
  }

  template <typename RandomAccessIterator,
	    typename ReadPM, typename ReadWritePM>
  inline void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end,
	   ReadPM read_pm, ReadWritePM readwrite_pm, cool::true_t const&)
  {
    typedef typename property_traits<ReadPM, RandomAccessIterator>::value_type value_type;
    pop_heap(begin, end, cool::less<value_type>(), read_pm, readwrite_pm);
  }

  template <typename RandomAccessIterator, typename T, typename PM>
  inline void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end, T t, PM pm)
  {
    pop_heap(begin, end, t, pm, typename cool::is_read_pm<T, RandomAccessIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator, typename BinaryPredicate>
  inline void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end,
	   BinaryPredicate pred, cool::false_t const&)
  {
    pop_heap(begin, end, pred, cool::identity_map());
  }

  template <typename RandomAccessIterator, typename ReadWritePM>
  inline void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end,
	   ReadWritePM readwrite_pm, cool::true_t const&)
  {
    typedef typename property_traits<ReadWritePM, RandomAccessIterator>::value_type value_type;
    pop_heap(begin, end, cool::less<value_type>(), readwrite_pm, readwrite_pm);
  }

  template <typename RandomAccessIterator, typename T>
  inline void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end, T t)
  {
    pop_heap(begin, end, t, typename cool::is_read_pm<T, RandomAccessIterator>::type());
  }

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator>
  inline void
  pop_heap(RandomAccessIterator begin, RandomAccessIterator end)
  {
    pop_heap(begin, end, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_POP_HEAP_HPP */
