// -*-C++-*- include/cool/algorithm/iter_swap.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the iter_swap() family of algorithms
// Version: $Id: iter_swap.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_ITER_SWAP_HPP)
#define COOL_ALGORITHM_ITER_SWAP_HPP 1

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------ 

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename ReadWritePM1, typename ReadWritePM2>
  void
  iter_swap(ForwardIterator1 it1, ForwardIterator2 it2,
	    ReadWritePM1 pm1, ReadWritePM2 pm2)
  {
    typedef typename cool::iterator_traits<ForwardIterator1>::key_type key_type;
    typedef typename cool::property_use_traits<ReadWritePM1, key_type>::value_type value_type;
    
    value_type tmp = get(pm1, *it1);
    put(pm1, *it1, get(pm2, *it2));
    put(pm2, *it2, tmp);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2>
  inline void
  iter_swap(ForwardIterator1 it1, ForwardIterator2 it2)
  {
    return cool::iter_swap(it1, it2, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_ITER_SWAP_HPP */
