// -*-C++-*- include/cool/algorithm/includes.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the includes() family of algorithms
// Version: $Id: includes.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_INCLUDES_HPP)
#define COOL_ALGORITHM_INCLUDES_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_LESS_HPP)
#  include "cool/functional/less.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  //-dk:TODO remove includes_pred_t with a generic predicate

  template <typename BinaryPredicate, typename T>
  struct includes_pred_t
  {
    typedef bool result_type;
    typedef typename BinaryPredicate::first_argument_type argument_type;

    includes_pred_t(BinaryPredicate pred, T const& v): m_pred(pred), m_value(v) {}

    bool operator()(argument_type const& a) {
      return !m_pred(a, m_value) && !m_pred(m_value, a);
    }
    
    BinaryPredicate m_pred;
    T               m_value;
  };

  template <typename BinaryPredicate, typename T>
  inline cool::includes_pred_t<BinaryPredicate, T>
  includes_pred(BinaryPredicate pred, T const& v)
  {
    return cool::includes_pred_t<BinaryPredicate, T>(pred, v);
  }

  // ------------------------------------------------------------------------
  // workhorse: includes()

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2>
  bool
  includes(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2,
	   BinaryPredicate pred,
	   ReadPM1 pm1, ReadPM2 pm2)
  {
    while (begin1 != end1
	   && (begin2 = cool::find_if(begin2, end2, includes_pred(pred, get(pm1, *begin1)), pm2)) != end2)
      ++begin1;
      
    return begin1 == end1;
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2,
	    typename ReadPM1, typename ReadPM2>
  inline bool
  includes(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2,
	   ReadPM1 pm1, ReadPM2 pm2)
  {
    typedef typename cool::iterator_traits<InputIterator1>::key_type          key_type;
    typedef typename cool::property_use_traits<ReadPM1, key_type>::value_type value_type;

    return cool::includes(begin1, end1, begin2, end2, cool::less<value_type>(), pm1, pm2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate>
  inline bool
  includes(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2,
	   BinaryPredicate pred)
  {
    return cool::includes(begin1, end1, begin2, end2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2>
  inline bool
  includes(InputIterator1 begin1, InputIterator1 end1,
	   InputIterator2 begin2, InputIterator2 end2)
  {
    return cool::includes(begin1, end1, begin2, end2, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_INCLUDES_HPP */
