// -*-C++-*- include/cool/algorithm/generate_n.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the generate_n() family of algorithms
// Version: $Id: generate_n.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_GENERATE_N_HPP)
#define COOL_ALGORITHM_GENERATE_N_HPP 1

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: generate_n()

  template <typename OutputIterator, typename Size, typename Generator, typename WritePM>
  OutputIterator
  generate_n(OutputIterator begin, Size size, Generator generator, WritePM pm)
  {
    for (; size-- > 0; ++begin)
      put(pm, *begin, generator());
    return begin;
  }

  // ------------------------------------------------------------------------

  template <typename OutputIterator, typename Size, typename Generator>
  inline OutputIterator
  generate_n(OutputIterator begin, Size size, Generator generator)
  {
    return cool::generate_n(begin, size, generator, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_GENERATE_N_HPP */
