// -*-C++-*- include/cool/algorithm/for_each.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   for_each() family of algorithms
// Version: $Id: for_each.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_FOR_EACH_HPP)
#define COOL_ALGORITHM_FOR_EACH_HPP 1

#if !defined(COOL_TRAITS_RETURN_TRAITS_HPP)
#  include "cool/traits/return_traits.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_HPP)
#  include "cool/property/identity_map.hpp"
#endif

#include <iterator>   //-dk:TODO remove
#include <functional> //-dk:TODO remove

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: for_each()

  template <typename InIt, typename Function, typename ReadPM>
  typename return_traits<Function, true>::return_type
  for_each(InIt begin, InIt end,
	   Function function,
	   ReadPM pm)
  {
    for (; begin != end; ++begin)
      function(get(pm, *begin));
    return function;
  }

  // ------------------------------------------------------------------------

  template <typename InIt, typename Function>
  typename return_traits<Function, true>::return_type
  for_each(InIt begin, InIt end,
	   Function function)
  {
    return cool::for_each(begin, end, function, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_FOR_EACH_HPP */
