// -*-C++-*- include/cool/algorithm/find_first_of.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the find_first_of() family of functions
// Version: $Id: find_first_of.hpp,v 1.1.1.1 2003/01/07 00:15:07 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_FIND_FIRST_OF_HPP)
#define COOL_ALGORITHM_FIND_FIRST_OF_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename BinaryPredicate, typename ReadPM>
  struct find_first_of_predicate
  {
    find_first_of_predicate(ForwardIterator begin, ForwardIterator end, 
			    BinaryPredicate pred, ReadPM pm):
      m_begin(begin), m_end(end),
      m_pred(pred),
      m_pm(pm)
      {
      }

    template <typename T>
    bool operator()(T const& val) const {
      return cool::find_if(m_begin, m_end, cool::bind1st(m_pred, val), m_pm) != m_end;
    }

    ForwardIterator m_begin, m_end;
    BinaryPredicate m_pred;
    ReadPM          m_pm;
  };
  
  template <typename ForwardIterator, typename BinaryPredicate, typename ReadPM>
  inline find_first_of_predicate<ForwardIterator, BinaryPredicate, ReadPM>
  find_first_of_pred(ForwardIterator begin, ForwardIterator end,
		     BinaryPredicate const& pred, ReadPM const& pm)
  {
    return cool::find_first_of_predicate<ForwardIterator, BinaryPredicate, ReadPM>(begin, end, pred, pm);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2>
  inline ForwardIterator1
  find_first_of(ForwardIterator1 begin1, ForwardIterator1 end1,
		ForwardIterator2 begin2, ForwardIterator2 end2,
		BinaryPredicate pred,
		ReadPM1 pm1, ReadPM2 pm2)
  {
    return cool::find_if(begin1, end1, cool::find_first_of_pred(begin2, end2, pred, pm2), pm1);
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename BinaryPredicate>
  inline ForwardIterator1
  find_first_of(ForwardIterator1 begin1, ForwardIterator1 end1,
		ForwardIterator2 begin2, ForwardIterator2 end2,
		BinaryPredicate pred)
  {
    return cool::find_first_of(begin1, end1, begin2, end2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2>
  inline ForwardIterator1
  find_first_of(ForwardIterator1 begin1, ForwardIterator1 end1,
		ForwardIterator2 begin2, ForwardIterator2 end2)
  {
    typedef typename cool::iterator_traits<ForwardIterator1>::key_type T1;
    typedef typename cool::iterator_traits<ForwardIterator2>::key_type T2;

    return cool::find_first_of(begin1, end1, begin2, end2, cool::equal_to<T1, T2>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_FIND_FIRST_OF_HPP */
