// -*-C++-*- include/cool/algorithm/find_end.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the find_end() family of algorithms
// Version: $Id: find_end.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_FIND_END_HPP)
#define COOL_ALGORITHM_FIND_END_HPP 1

#if !defined(COOL_ALGORITHM_FIND_HPP)
#  include "cool/algorithm/find.hpp"
#endif
#if !defined(COOL_ALGORITHM_MISMATCH_HPP)
#  include "cool/algorithm/mismatch.hpp"
#endif
#if !defined(COOL_ALGORITHM_NEXT_HPP)
#  include "cool/algorithm/next.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_BIND_HPP)
#  include "cool/functional/bind.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------
  //-dk:TODO optimize for Bidirectional iterators

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2>
  ForwardIterator1
  find_end(ForwardIterator1 begin1, ForwardIterator1 end1,
	   ForwardIterator2 begin2, ForwardIterator2 end2,
	   BinaryPredicate pred,
	   ReadPM1 pm1, ReadPM2 pm2)
  {
    ForwardIterator1 last = end1;
    ForwardIterator2 first = begin2;
    ++begin2;

    for (; (begin1 = cool::find_if(begin1, end1, cool::bind2nd(pred, get(pm2, *first)), pm1)) != end1; ++begin1)
      if (cool::mismatch(cool::next(begin1), end1, begin2, end2, pred, pm1, pm2).second == end2)
	last = begin1;

    return last;
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2,
	    typename BinaryPredicate>
  ForwardIterator1
  find_end(ForwardIterator1 begin1, ForwardIterator1 end1,
	   ForwardIterator2 begin2, ForwardIterator2 end2,
	   BinaryPredicate pred)
  {
    return cool::find_end(begin1, end1, begin2, end2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator1, typename ForwardIterator2>
  ForwardIterator1
  find_end(ForwardIterator1 begin1, ForwardIterator1 end1,
	   ForwardIterator2 begin2, ForwardIterator2 end2)
  {
    typedef typename cool::iterator_traits<ForwardIterator1>::key_type T1;
    typedef typename cool::iterator_traits<ForwardIterator2>::key_type T2;

    return cool::find_end(begin1, end1, begin2, end2, cool::equal_to<T1, T2>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_FIND_END_HPP */
