// -*-C++-*- include/cool/algorithm/find.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   Family of find algorithms
// Version: $Id: find.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_FIND_HPP)
#define COOL_ALGORITHM_FIND_HPP 1

#if !defined(COOL_PROPERTY_IDENTITY_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#include <functional>

namespace cool
{

  // ------------------------------------------------------------------------
  // workhorse: find_if
  // An algorithm doing effective work on the sequence:

  template <typename InputIterator, typename UnaryPredicate, typename ReadPM>
  InputIterator
  find_if(InputIterator begin, InputIterator end,
	  UnaryPredicate pred,
	  ReadPM pm)
  {
    for (; !(begin == end); ++begin)
      if (pred(get(pm, *begin)))
	break;
    return begin;
  }

  // ------------------------------------------------------------------------
  // deprecated:

  template <typename InputIterator, typename UnaryPredicate>
  inline InputIterator
  find_if(InputIterator begin, InputIterator end,
	  UnaryPredicate pred)
  {
    return find_if(begin, end, pred, identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator, typename T, typename ReadPM>
  inline InputIterator
  find(InputIterator begin,
       InputIterator end,
       T const& val, ReadPM pm)
  {
    return find_if(begin, end, bind2nd(std::equal_to<T>(), val), pm);
  }

  // ------------------------------------------------------------------------
  // deprecated:

  template <typename InputIterator, typename T>
  inline InputIterator
  find(InputIterator begin, InputIterator end,
       T const& val)
  {
    return cool::find_if(begin, end, bind2nd(std::equal_to<T>(), val));
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_FIND_HPP */
