// -*-C++-*- include/cool/algorithm/fill_n.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the fill_n() family of algorithms
// Version: $Id: fill_n.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_FILL_N_HPP)
#define COOL_ALGORITHM_FILL_N_HPP 1

#if !defined(COOL_ALGORITHM_GENERATE_N_HPP)
#  include "cool/algorithm/generate_n.hpp"
#endif

#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_CONSTANT_HPP)
#  include "cool/functional/constant.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename OutputIterator, typename Size, typename T, typename WritePM>
  inline OutputIterator
  fill_n(OutputIterator begin, Size size, T const& val, WritePM pm)
  {
    return cool::generate_n(begin, size, cool::constant(val), pm);
  }

  // ------------------------------------------------------------------------

  template <typename OutputIterator, typename Size, typename T>
  inline OutputIterator
  fill_n(OutputIterator begin, Size size, T const& val)
  {
    return cool::fill_n(begin, size, val, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_FILL_N_HPP */
