// -*-C++-*- include/cool/algorithm/equal.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   equal() family of algorithms
// Version: $Id: equal.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_EQUAL_HPP)
#define COOL_ALGORITHM_EQUAL_HPP 1

#if !defined(COOL_ALGORITHM_MISMATCH_HPP)
#  include "cool/algorithm/mismatch.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_TRAITS_PROPERTY_HPP)
#  include "cool/traits/property.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to_hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2>
  inline bool
  equal(InputIterator1 begin1, InputIterator1 end1,
	InputIterator2 begin2,
	BinaryPredicate pred,
	ReadPM1 pm1, ReadPM2 pm2)
  {
    return cool::mismatch(begin1, end1, begin2, pred, pm1, pm2).first == end1;
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate>
  inline bool
  equal(InputIterator1 begin1, InputIterator1 end1,
	InputIterator2 begin2,
	BinaryPredicate pred)
  {
    return cool::equal(begin1, end1, begin2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2>
  inline bool
  equal(InputIterator1 begin1, InputIterator1 end1,
	InputIterator2 begin2)
  {
    typedef typename cool::iterator_traits<InputIterator1>::key_type T1;
    typedef typename cool::iterator_traits<InputIterator2>::key_type T2;

    return cool::equal(begin1, end1, begin2, cool::equal_to<T1, T2>());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate,
	    typename ReadPM1, typename ReadPM2>
  inline bool
  equal(InputIterator1 begin1, InputIterator1 end1,
	InputIterator2 begin2, InputIterator2 end2,
	BinaryPredicate pred,
	ReadPM1 pm1, ReadPM2 pm2)
  {
    return cool::mismatch(begin1, end1, begin2, end2, pred, pm1, pm2) == std::make_pair(end1, end2);
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2, typename BinaryPredicate>
  inline bool
  equal(InputIterator1 begin1, InputIterator1 end1,
	InputIterator2 begin2, InputIterator2 end2,
	BinaryPredicate pred)
  {
    return cool::equal(begin1, end1, begin2, end2, pred, cool::identity_map(), cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename InputIterator1, typename InputIterator2>
  inline bool
  equal(InputIterator1 begin1, InputIterator1 end1,
	InputIterator2 begin2, InputIterator2 end2)
  {
    typedef typename cool::iterator_traits<InputIterator1>::key_type T1;
    typedef typename cool::iterator_traits<InputIterator2>::key_type T2;

    return cool::equal(begin1, end1, begin2, end2, cool::equal_to<T1, T2>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_EQUAL_HPP */
