// -*-C++-*- include/cool/algorithm/distance.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the distance() family of algorithms
// Version: $Id: distance.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_DISTANCE_HPP)
#define COOL_ALGORITHM_DISTANCE_HPP 1

#if !defined(COOL_ALGORITHM_FOR_EACH_HPP)
#  include "cool/algorithm/for_each.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename Difference>
  struct distance_functor
  {
    distance_functor(): difference() {}
    template <typename T> void operator()(T const&) { ++difference; }
    Difference difference;
  };

  template <typename InputIterator,
	    typename Category = typename cool::iterator_traits<InputIterator>::iterator_category>
  struct distance_aux
  {
    static inline typename cool::iterator_traits<InputIterator>::difference_type
    distance(InputIterator begin, InputIterator end)
    {
      return cool::for_each(begin, end,
			    distance_functor<typename cool::iterator_traits<InputIterator>::difference_type>(),
			    cool::identity_map()).difference;
    }
  };

  // ------------------------------------------------------------------------

  template <typename RandomAccessIterator>
  struct distance_aux<RandomAccessIterator, cool::random_access_iterator_tag>
  {
    static inline typename cool::iterator_traits<RandomAccessIterator>::difference_type
    distance(RandomAccessIterator begin, RandomAccessIterator end)
    {
      return end - begin;
    }
  };

  // ------------------------------------------------------------------------

  template <typename InputIterator>
  typename cool::iterator_traits<InputIterator>::difference_type
  distance(InputIterator begin, InputIterator end)
  {
    return cool::distance_aux<InputIterator>::distance(begin, end);
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_DISTANCE_HPP */
