// -*-C++-*- inlcude/cool/algorithm/copy_backward.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   the copy_backward() family of algorithms
// Version: $Id: copy_backward.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_COPY_BACKWARD_HPP)
#define COOL_ALGORITHM_COPY_BACKWARD_HPP 1

#if !defined(COOL_ALGORITHM_COPY_HPP)
#  include "cool/algorithm/copy.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#include <iterator> //-dk:TODO remove

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator1, typename BidirectionalIterator2,
	    typename ReadPM, typename WritePM>
  inline BidirectionalIterator2
  copy_backward(BidirectionalIterator1 begin1, BidirectionalIterator1 end1,
		BidirectionalIterator2 end2,
		ReadPM read_pm, WritePM write_pm)
  {
    return cool::copy(std::reverse_iterator<BidirectionalIterator1>(end1),
		      std::reverse_iterator<BidirectionalIterator1>(begin1),
		      std::reverse_iterator<BidirectionalIterator2>(end2), read_pm, write_pm).base();
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator1, typename BidirectionalIterator2,
	    typename ReadPM>
  inline BidirectionalIterator2
  copy_backward(BidirectionalIterator1 begin1, BidirectionalIterator1 end1,
		BidirectionalIterator2 end2,
		ReadPM read_pm)
  {
    return cool::copy_backward(begin1, end1, end2, read_pm, cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename BidirectionalIterator1, typename BidirectionalIterator2>
  inline BidirectionalIterator2
  copy_backward(BidirectionalIterator1 begin1, BidirectionalIterator1 end1,
		BidirectionalIterator2 end2)
  {
    return cool::copy_backward(begin1, end1, end2, cool::identity_map());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_COPY_BACKWARD_HPP */
