// -*-C++-*- include/cool/algorithm/adjacent_find.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2002 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   adjacent_find() family of algorithms
// Version: $Id: adjacent_find.hpp,v 1.1.1.1 2003/01/07 00:15:08 kuehl Exp $ 

// ----------------------------------------------------------------------- 

#if !defined(COOL_ALGORITHM_ADJACENT_FIND_HPP)
#define COOL_ALGORITHM_ADJACENT_FIND_HPP 1

#if !defined(COOL_ALGORITHM_MISMATCH_HPP)
#  include "cool/algorithm/mismatch.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_EQUAL_TO_HPP)
#  include "cool/functional/equal_to.hpp"
#endif
#if !defined(COOL_TRAITS_ITERATOR_HPP)
#  include "cool/traits/iterator.hpp"
#endif
#if !defined(COOL_PROPERTY_IDENTITY_MAP_HPP)
#  include "cool/property/identity_map.hpp"
#endif
#if !defined(COOL_FUNCTIONAL_NOT_HPP)
#  include "cool/functional/not.hpp"
#endif

namespace cool
{

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename BinaryPredicate, typename ReadPM>
  inline ForwardIterator
  adjacent_find(ForwardIterator begin, ForwardIterator end,
		BinaryPredicate pred,
		ReadPM pm)
  {
    ForwardIterator next = begin;
    std::pair<ForwardIterator, ForwardIterator> const& p = cool::mismatch(++next, end, begin, cool::not2(pred), pm, pm);
    return p.first == end? p.first: p.second;
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator, typename BinaryPredicate>
  inline ForwardIterator
  adjacent_find(ForwardIterator begin, ForwardIterator end, BinaryPredicate pred)
  {
    return adjacent_find(begin, end, pred, cool::identity_map());
  }

  // ------------------------------------------------------------------------

  template <typename ForwardIterator>
  inline ForwardIterator
  adjacent_find(ForwardIterator begin, ForwardIterator end)
  {
    return adjacent_find(begin, end,
			 cool::equal_to<typename cool::iterator_traits<ForwardIterator>::key_type>());
  }

  // ------------------------------------------------------------------------

} // namespace cool

#endif /* COOL_ALGORITHM_ADJACENT_FIND_HPP */
