// -*-C++-*- enable_if.hpp
// ----------------------------------------------------------------------- 
//  Copyright  2005 Dietmar Khl, All Rights Reserved                     
//                                                                         
//  Permission to use, copy, modify, distribute and sell this              
//  software for any purpose is hereby granted without fee, provided       
//  that the above copyright notice appears in all copies and that         
//  both that copyright notice and this permission notice appear in        
//  supporting documentation. Dietmar Khl makes no representations about  
//  the suitability of this software for any purpose. It is provided       
//  "as is" without express or implied warranty.                           
// ----------------------------------------------------------------------- 

// Author:  Dietmar Kuehl http://www.dietmar-kuehl.de 
// Title:   a simple device to take advantage of SFINAE for functions

// ----------------------------------------------------------------------- 

#if !defined(COOL_ENABLE_IF_HPP)
#define COOL_ENABLE_IF_HPP 1

namespace cool
{
  // ---------------------------------------------------------------------
  // enable_if

  template <bool, typename>
  struct enable_if
  {
  };

  template <typename T>
  struct enable_if<true, T>
  {
    typedef T type;
  };

  // ---------------------------------------------------------------------
}

#endif /* COOL_ENABLE_IF_HPP */
