  // mod 127
  // cout << mt(78) * mt(113) / mt(90) << endl; // 81
  // cout << mt(78) * mt(78) * mt(78) * mt(78) * mt(78) * mt(78) * mt(78) * mt(78) << endl; // 78^8 = 35

  /* for (int i= 1; i < n; i++) {
    modN_t<n> v(i);
    cout << v << " inv = " << modNMult.inverse(v) << " test: " << modNMult.inverse(v) * v << "\n"; }
  */ 

  template <class T>
  struct is_associative {
    static const bool value= is_base_and_derived<def::associativity_marker, T>::value;
  };

  template <class T>
  struct is_commutative {
    static const bool value= is_base_and_derived<def::commutativity_marker, T>::value;
  };


struct multiplyAndSquare_t {
  // checks commutativity of Op, does not compile otherwise
  template <class T, class Op>
  inline typename enable_if<glas::is_commutative<Op>::value, T>::type
  // inline T
  operator() (T base, int exp, Op op) {
    cout << "Use multiplyAndSquare\n";
    T value(op.identity()), square(base);
    for (; exp > 0; exp>>= 1) {
      if (exp & 1) value= op(value, square);
      square= op(square, square); }
    return value; } 
} multiplyAndSquare;

struct slowExponation_t {
  template <class T, class Op>
  inline T operator() (T base, int exp, Op op) {
    cout << "Use slowExponation\n";
    T value(op.identity());
    for (; exp > 0; exp--) 
      value= op(value, base);
    return value; }
} slowExponation;
  
template <class T, class Op>
inline T exponation(T base, int exp, Op op) {
  typename if_type<glas::is_commutative<Op>::value, multiplyAndSquare_t, slowExponation_t>::type func;
  return func(base, exp, op);
}

template <class Iter, class Op>
inline typename std::iterator_traits<Iter>::value_type
trySortedAccumulate(Iter first, Iter last, Op op) {
  typedef typename std::iterator_traits<Iter>::iterator_category Cat;
  static const bool random_access= boost::is_same<Cat, std::random_access_iterator_tag>::value;
  typename if_type<glas::is_commutative<Op>::value && random_access,
                   sortedAccumulate_t, unsortedAccumulate_t>::type  accumulate;
  return accumulate(first, last, op);
}



  typedef magmaMultOp<int>         m;
  typedef semiGroupMultOp<int>     sg;
  typedef commSemiGroupMultOp<int> csg;
  typedef monoidMultOp<int>        mo; 
  typedef commMonoidMultOp<int>    cmo;
  typedef groupMultOp<int>         g;
  typedef abeleanGroupMultOp<int>  ag;
  int array[7] = {1, 2, 3, 4, 5, 6, 7};
 
  cout << "m   a: " <<  glas::is_op_associative<m>::value << " c: " << glas::is_op_commutative<m>::value << endl;
  cout << "sg  a: " <<  glas::is_op_associative<sg>::value << " c: " << glas::is_op_commutative<sg>::value << endl;
  cout << "csg a: " <<  glas::is_op_associative<csg>::value << " c: " << glas::is_op_commutative<csg>::value << endl;
  cout << "mo  a: " <<  glas::is_op_associative<mo>::value << " c: " << glas::is_op_commutative<mo>::value << endl;
  cout << "cmo  a: " <<  glas::is_op_associative<cmo>::value << " c: " << glas::is_op_commutative<cmo>::value << endl;
  cout << "g  a: " <<  glas::is_op_associative<g>::value << " c: " << glas::is_op_commutative<g>::value << endl;
  cout << "ag  a: " <<  glas::is_op_associative<ag>::value << " c: " << glas::is_op_commutative<ag>::value << endl;
 
  cout << "mo  a: " << trySortedAccumulate(array, array+7, mo()) << endl; 
  cout << "cmo  a: " <<  trySortedAccumulate(array, array+7, cmo()) << endl; 
  cout << "g  a: " <<  trySortedAccumulate(array, array+7, g()) << endl;
  cout << "ag  a: " <<  trySortedAccumulate(array, array+7, ag()) << endl;
 
private:
  template <class T>
  struct absLess_t {
    bool operator() (const T& x, const T& y) {
      return abs(x) < abs(y); }
  }; 
 public:
