#ifndef property_traits_include
#define property_traits_include

#include <boost/type_traits.hpp>
#include "default_functors.hpp"

namespace glas {

  template <class T>
  struct is_op_associative {
    static const bool value= boost::is_base_and_derived<def::associativity_marker, T>::value;
  };

  template <class T>
  struct is_op_commutative {
    static const bool value= boost::is_base_and_derived<def::commutativity_marker, T>::value;
  };
  
} // namespace glas

#endif // property_traits_include
