#include <iostream.h>

#include "glas.hpp"
#include "algebraic_functions.hpp"

template<unsigned n>
class modN_t {
  unsigned value;
 public:
  // const unsigned myN= n;
  modN_t(int v) {
    value= v >= 0 ? v%n : n - -v%n; }// modulo of negative numbers can be bizarre
  modN_t(const modN_t<n>& m): value(m.get()) {}
  modN_t<n>& operator= (const modN_t<n>& m) {
    value= m.value; return *this; }
  template<unsigned OtherN>
  modN_t<n>& convert(const modN_t<OtherN>& m) {
    value= m.value >= 0 ? m.value%n : n - -m.value%n; return *this; }
  unsigned get() const {
    return value; }
};

template<unsigned n>
inline ostream& operator<< (ostream& stream, const modN_t<n>& a) {
  return stream << a.get(); }

template<unsigned n>
inline bool operator==(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() == y.get(); } 

template<unsigned n>
inline bool operator>=(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() >= y.get(); } 

template<unsigned n>
inline bool operator<=(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() <= y.get(); } 

template<unsigned n>
inline bool operator>(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() > y.get(); } 

template<unsigned n>
inline bool operator<(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() < y.get(); } 

template<unsigned n>
inline modN_t<n> operator+ (const modN_t<n>& x, const modN_t<n>& y) {
  return modN_t<n>(x.get() + y.get()); } 

template<unsigned n>
inline modN_t<n> operator- (const modN_t<n>& x, const modN_t<n>& y) {
  // add n to avoid negative numbers
  return modN_t<n>(n + x.get() - y.get()); } 

template<unsigned n>
inline modN_t<n> operator* (const modN_t<n>& x, const modN_t<n>& y) {
  return modN_t<n>(x.get() * y.get()); } 

template<unsigned n>
inline modN_t<n> operator/ (const modN_t<n>& x, const modN_t<n>& y) {
  if (y.get() == 0) throw "Division by 0";
  int u= y.get(), v= n, x1= 1, x2= 0, q, r, x0;
  while (u != 1) {
    q= v/u; r= v%u; x0= x2 - q*x1; 
    v=u; u= r; x2= x1; x1= x0; }
  return modN_t<n>(x.get() * x1); 
} 

// definitions of +=, -= etc should be added here

int main(int, char* []) {
  typedef modN_t<127>             mytype;
  glas::def::groupMultOp<mytype>  mymult;
  mytype   v78(78), v113(113), v90(90), v80(80);
 
  cout << "equalResults(v78, v113,  v90, v80, mymult) "
       << equalResults(v78, v113,  v90, v80, mymult) << endl;
  cout << "equalResults(v78, v113,  v90, mytype(81), mymult) "
       << equalResults(v78, v113,  v90, mytype(81), mymult) << endl;
  cout << "identityPair(v78, mytype(-78), mymult) "
       << identityPair(v78, mytype(-78), mymult) << endl;
  cout << "identityPair(v78, mytype(57), mymult) "
       << identityPair(v78, mytype(57), mymult) << endl;
  cout << "poorMensDivision(mytype(8), mytype(2), mymult) = log_2 (8) "
       << poorMensDivision(mytype(8), mytype(2), mymult) << endl;
  cout << "poorMensDivision(mytype(35), v78, mymult) = log_78 (35) "
       << poorMensDivision(mytype(35), v78, mymult) << endl;
  return 0; 
}
 
