#include <iostream.h>

#include "glas.hpp"
#include "algebraic_functions.hpp"

template<unsigned n>
class modN_t {
  unsigned value;
 public:
  // const unsigned myN= n;
  modN_t(int v) {
    value= v >= 0 ? v%n : n - -v%n; }// modulo of negative numbers can be bizarre
  modN_t(const modN_t<n>& m): value(m.get()) {}
  modN_t<n>& operator= (const modN_t<n>& m) {
    value= m.value; return *this; }
  template<unsigned OtherN>
  modN_t<n>& convert(const modN_t<OtherN>& m) {
    value= m.value >= 0 ? m.value%n : n - -m.value%n; return *this; }
  unsigned get() const {
    return value; }
};

template<unsigned n>
inline ostream& operator<< (ostream& stream, const modN_t<n>& a) {
  return stream << a.get(); }

template<unsigned n>
inline bool operator==(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() == y.get(); } 

template<unsigned n>
inline bool operator>=(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() >= y.get(); } 

template<unsigned n>
inline bool operator<=(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() <= y.get(); } 

template<unsigned n>
inline bool operator>(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() > y.get(); } 

template<unsigned n>
inline bool operator<(const modN_t<n>& x, const modN_t<n>& y) {
  return x.get() < y.get(); } 

template<unsigned n>
struct modNAdd_t { // : magmaAdd<modN_t<n> > {
  modN_t<n> operator() (const modN_t<n>& x, const modN_t<n>& y) {
    return modN_t<n>(x.get() + y.get()); } 
  modN_t<n> identity() {
    return modN_t<n>(0); }
  modN_t<n> inverse(const modN_t<n>& x) {
    return modN_t<n>(n-x.get()); } 
};

template<unsigned n>
struct modNMult_t { 
  modN_t<n> operator() (const modN_t<n>& x, const modN_t<n>& y) {
    return modN_t<n>(x.get() * y.get()); } 
  modN_t<n> identity() {
    return modN_t<n>(1); }
  modN_t<n> inverse(const modN_t<n>& a) {
    if (a.get() == 0) throw "Division by 0";
    int u= a.get(), v= n, x1= 1, x2= 0, q, r, x;
    while (u != 1) {
      q= v/u; r= v%u; x= x2 - q*x1; 
      v=u; u= r; x2= x1; x1= x; }
    return modN_t<n>(x1); } 
};


template<unsigned n>
inline modN_t<n> operator+ (const modN_t<n>& x, const modN_t<n>& y) {
  return modNAdd_t<n>()(x, y); } 

template<unsigned n>
inline modN_t<n> operator- (const modN_t<n>& x, const modN_t<n>& y) {
  modNAdd_t<n> add;
  return add(x, add.inverse(y)); } 

template<unsigned n>
inline modN_t<n> operator* (const modN_t<n>& x, const modN_t<n>& y) {
  return modNMult_t<n>()(x, y); } 

template<unsigned n>
inline modN_t<n> operator/ (const modN_t<n>& x, const modN_t<n>& y) {
  modNMult_t<n> mult;
  return mult(x, mult.inverse(y)); } 



int main(int, char* []) {

  // using namespace glas::def;
  const unsigned n= 127;
  typedef modN_t<n>       mytype;
  modNMult_t<n>           mymult;
 
  cout << "equalResults(mytype(78), mytype(113),  mytype(90), mytype(80), mymult) "
       << equalResults(mytype(78), mytype(113),  mytype(90), mytype(80), mymult) << endl;
  cout << "equalResults(mytype(78), mytype(113),  mytype(90), mytype(81), mymult) "
       << equalResults(mytype(78), mytype(113),  mytype(90), mytype(81), mymult) << endl;
  cout << "identityPair(mytype(78), mytype(-78), mymult) "
       << identityPair(mytype(78), mytype(-78), mymult) << endl;
  cout << "identityPair(mytype(78), mytype(57), mymult) "
       << identityPair(mytype(78), mytype(57), mymult) << endl;
  cout << "poorMensDivision(mytype(8), mytype(2), mymult) = log_2 (8) "
       << poorMensDivision(mytype(8), mytype(2), mymult) << endl;
  cout << "poorMensDivision(mytype(35), mytype(78), mymult) = log_78 (35) "
       << poorMensDivision(mytype(35), mytype(78), mymult) << endl;
  return 0; 
}

