// default_functors_wo_markers.hpp, is an earlier version of default functors
#ifndef glas_default_functors_include
#define glas_default_functors_include

namespace glas { namespace def {

  template <class T>
  class magmaAddOp {
  public:
    T operator() (const T& x, const T& y) {
      return x + y; }
  };

  template <class T, class Base= magmaAddOp<T> >
  class semiGroupAddOp: public Base {};

  template <class T, class Base= semiGroupAddOp<T> >
  class commSemiGroupAddOp: public Base {};

  template <class T, class Base= semiGroupAddOp<T> >
  class monoidAddOp: public Base {
  public:
    T identity() {
      return T(0); }
  };

  template <class T, class Base= monoidAddOp<T> >
  class commMonoidAddOp: public Base {};

  template <class T, class Base= monoidAddOp<T> >
  class groupAddOp: public Base {
  public:
    T inverse(const T& x) {
      return identity() - x; }
  };
  
  template <class T, class Base= groupAddOp<T> >
  class abeleanGroupAddOp: public Base {};

  template <class T>
  class magmaMultOp {
  public:
    T operator() (const T& x, const T& y) {
      return x * y; }
  };

  template <class T, class Base= magmaMultOp<T> >
  class semiGroupMultOp: public Base {};

  template <class T, class Base= semiGroupMultOp<T> >
    class commSemiGroupMultOp: public Base {};

  template <class T, class Base= semiGroupMultOp<T> >
  class monoidMultOp: public Base {
  public:
    T identity() {
      return T(1); }
  };

  template <class T, class Base= monoidMultOp<T> >
  class commMonoidMultOp: public Base {};

  template <class T, class Base= monoidMultOp<T> >
  class groupMultOp: public Base {
  public:
    T inverse(const T& x) {
      return identity() / x; }
  };
  
  template <class T, class Base= groupMultOp<T> >
  class abeleanGroupMultOp: public Base {};

} // namespace def
} // namespace glas

#endif // glas_default_functors_include
