#include <iostream.h>
#include <cmath>

#include "algebraic_functions.hpp"
#include "glas.hpp"

// User defined data types and operators
class age {
  double myAge;
 public:
  age(double m): myAge(m) {
    if (m < 0.0) throw "Negative Age"; }
  double sayAge() const {
    return myAge; }
  friend age& operator+=(age&, const age&);
};

inline bool operator==(const age& x, const age& y) {
  return x.sayAge() == y.sayAge(); }

inline ostream& operator<< (ostream& stream, const age& a) {
  return stream << a.sayAge(); }

// Another functor on age
struct pythagoras_t {
  age operator() (const age& x, const age& y) {
    return age(sqrt(x.sayAge()*x.sayAge() + y.sayAge()*y.sayAge())); }
} pythagoras;


int main(int, char* []) {
  age a0(0.0), a2(2.0), a3(3.0), a4(4.0), a5(5.0);
  glas::def::monoidAddOp<age, pythagoras_t>  pMonoid;
  
  cout << "equalResults(a0,a5,  a3,a4, pythagoras) " 
       << equalResults(a0,a5,  a3,a4, pythagoras)  << endl;
  cout << "equalResults(a2,a4,  a3,a3, pythagoras) " 
       << equalResults(a2,a4,  a3,a3, pythagoras)  << endl;
  cout << "identityPair(a2,a4, pMonoid) " 
       << identityPair(a2,a4, pMonoid)  << endl;
  cout << "identityPair(a0,a0, pMonoid) " 
       << identityPair(a0,a0, pMonoid)  << endl; 
 
  return 0;
}
