// age_example1f.cpp
#include <iostream.h>
#include "algebraic_functions.hpp"

// User defined data types and operators
class age {
  double myAge;
 public:
  age(double m): myAge(m) {
    if (m < 0.0) throw "Negative Age"; }
  double sayAge() const {
    return myAge; }
};

inline bool operator==(const age& x, const age& y) {
  return x.sayAge() == y.sayAge(); }

inline ostream& operator<< (ostream& stream, const age& a) {
  return stream << a.sayAge(); }

// User defined functor which build a commutative monoid with age
struct ageAdd_t {
  age operator() (const age& x, const age& y) {
  return age(x.sayAge() + y.sayAge()); }
  age identity() {
    return age(0); }
} ageAdd;

int main(int, char* []) {
  age a0(0.0), a2(2.0), a3(3.0), a4(4.0), a5(5.0);
  
  cout << "equalResults(a2,a5,  a3,a4, ageAdd) " 
       << equalResults(a2,a5,  a3,a4, ageAdd)  << endl;
  cout << "equalResults(a2,a4,  a3,a4, ageAdd) " 
       << equalResults(a2,a4,  a3,a4, ageAdd)  << endl;
  cout << "identityPair(a2,a4, ageAdd) " 
       << identityPair(a2,a4, ageAdd)  << endl;
  cout << "identityPair(a0,a0, ageAdd) " 
       << identityPair(a0,a0, ageAdd)  << endl;
 
  return 0;
}

